﻿unit Between_Dates;

interface

uses
  //GUI, 
  Classes, Common, DataEntry, DataStorage, DateUtils, Graphics, Math, Regex, SysUtils, Variants;

const
  ATRY_EXCEPT_STR = 'Exception';
  CHAR_LENGTH = 80;
  RPAD_VALUE = 35;
  SPACE = ' ';
  
  TASKLIST_BETWEEN_DATES = 'Between Dates (Created, Modified, Accessed)'; // Must match the exact text in the TXML
  TASKLIST_START_DATE = 'Start Date:';
  TASKLIST_END_DATE = 'End Date:';  

implementation

function ShellExecute(hWnd: cardinal; lpOperation: PChar; lpFile: PChar; lpParameter: PChar; lpDirectory: PChar; nShowCmd: integer): Thandle; stdcall; external 'Shell32.Dll' Name 'ShellExecuteW';

//------------------------------------------------------------------------------
// Procedure: Right Pad
//------------------------------------------------------------------------------
function RPad(Astring: string; AChars: integer): string;
begin
  while length(Astring) < AChars do
    Astring := Astring + ' ';
  Result := Astring;
end;

//------------------------------------------------------------------------------
// Start of Script
//------------------------------------------------------------------------------
var
  anEntry: TEntry;
  btwn_dates_LogFileFullPath_str: string;
  bl_tasklist_between_dates_bl: boolean;  
  end_date_dt: TDateTime;
  end_date_str: string;
  i: integer;
  in_range_count: integer;
  out_range_count: integer;
  start_date_dt: TDateTime;
  start_date_str: string;

begin
  Progress.Log(StringOfChar('-', CHAR_LENGTH));
  if assigned(inList) then
    Progress.Log(RPad('InList Count:', RPAD_VALUE) + inttostr(inList.Count))
  else
  begin
    Progress.Log('No inList');
  end;
  Progress.Log(StringOfChar('-', CHAR_LENGTH));
  
  //--------------------------------------------------------------------------
  // ScriptTask: TASKLIST - Between Dates
  //--------------------------------------------------------------------------
  bl_tasklist_between_dates_bl := False;
  if RegexMatch(ScriptTask.GetTaskListOption(TASKLIST_BETWEEN_DATES), 'True', False) then    
  begin
    // TASKLIST - Start Date
    start_date_str := ScriptTask.GetTaskListOption(TASKLIST_START_DATE);
    if trim(start_date_str) = '' then
    begin      
      Progress.Log('Error reading input form - Date Start.');
      bl_tasklist_between_dates_bl := False;
    end
    else
    begin
      try
        start_date_dt := VarToDateTime(start_date_str);
        bl_tasklist_between_dates_bl := True;
      except
        Progress.Log(ATRY_EXCEPT_STR + 'Error start_date_str to DT: ' + start_date_str);
        bl_tasklist_between_dates_bl := False;
      end;
    end;

    // TASKLIST - End Date
    end_date_str := ScriptTask.GetTaskListOption(TASKLIST_END_DATE);
    if trim(end_date_str) = '' then
    begin
      Progress.Log('Error reading input form - Date End.');
      bl_tasklist_between_dates_bl := False;
    end
    else if bl_tasklist_between_dates_bl = True then
    begin
      try
        end_date_dt := VarToDateTime(end_date_str);
      except
        Progress.Log(ATRY_EXCEPT_STR + 'Error end_date_str to DT: ' + end_date_str);
        bl_tasklist_between_dates_bl := False;
      end;
    end;
  end;

  //--------------------------------------------------------------------------
  // Logging Start and End dates
  //--------------------------------------------------------------------------  
  Progress.Log(RPad('Between Dates Checkbox:', RPAD_VALUE) + BoolToStr(bl_tasklist_between_dates_bl, True));
  if bl_tasklist_between_dates_bl then
  try
    Progress.Log(RPad('Start Date:', RPAD_VALUE) + DateTimeToStr(start_date_dt));
    Progress.Log(RPad('End Date:', RPAD_VALUE) + DateTimeToStr(end_date_dt));
    Progress.Log(StringOfChar('-', CHAR_LENGTH));  
  except
    Progress.Log(RPad('Param Start Date:', RPAD_VALUE) + 'Error converting DT to Str');
    bl_tasklist_between_dates_bl := False;
    Progress.Log(RPad('Between Dates Checkbox:', RPAD_VALUE) + 'Set to false.');
  end;
  
  //----------------------------------------------------------------------------
  // Process Files
  //----------------------------------------------------------------------------
  Progress.Log(RPad('All Files:', RPAD_VALUE) + inttostr(inList.Count));
  for i := 0 to inList.Count - 1 do
  begin
    anEntry := TEntry(inList[i]);
    if assigned(anEntry) then
    begin
      // -----------------------------------------------------------------------
      // If working between dates
      // -----------------------------------------------------------------------
      if bl_tasklist_between_dates_bl then
      begin
        if (CompareDate(anEntry.Created, start_date_dt)=-1) or (CompareDate(anEntry.Created, end_date_dt)=1) then
        begin
          //Progress.Log(DateTimeToStr(start_dt) + ' >>> ' + DateTimeToStr(anEntry.Created) + ' >>> ' + DateTimeToStr(end_dt) + SPACE + 'No');
          out_range_count := out_range_count + 1;
        end
        else
        begin
          //Progress.Log(DateTimeToStr(start_dt) + ' >>> ' + DateTimeToStr(anEntry.Created) + ' >>> ' + DateTimeToStr(end_dt) + SPACE + 'Yes');
          in_range_count := in_range_count + 1;
          OutList.add(anEntry);            
        end
      end
      else
      // -----------------------------------------------------------------------
      // If NOT working between dates
      // -----------------------------------------------------------------------
      begin
        OutList.add(anEntry);
      end;  
    end;
  end;
  
  // ---------------------------------------------------------------------------
  // Logging
  // ---------------------------------------------------------------------------
  Progress.Log(StringOfChar('-', CHAR_LENGTH));
  
  if bl_tasklist_between_dates_bl then
  begin
    Progress.Log(RPad('In Range:', RPAD_VALUE) + inttostr(in_range_count));
    Progress.Log(RPad('Out of Range:', RPAD_VALUE) + inttostr(out_range_count));
    Progress.Log(StringOfChar('-', CHAR_LENGTH));
  end;
  
  Progress.Log(RPad('OutList on finish:', rpad_value) + IntToStr(OutList.Count));  
  Progress.Log('Finished.');
  
  if RegexMatch(ScriptTask.GetTaskListOption('OPENLOG'), 'True', False) then
  begin
    btwn_dates_LogFileFullPath_str := GetCurrentCaseDir + 'Logs' + '\' + 'SCRIPT - Between Dates' + '.log';
    if FileExists(btwn_dates_LogFileFullPath_str) then
    begin
      ShellExecute(0, nil, 'explorer.exe', pchar(btwn_dates_LogFileFullPath_str), nil, 1);
    end
    else
      Progress.Log(RPad('Did not find log file:', RPAD_VALUE) + btwn_dates_LogFileFullPath_str);    
  end
  else
    Progress.Log('No OPENLOG');  
  
end.
